#pragma once
#include "Light.h"
class SpotLight : public Light
{
	public:
		SpotLight(int id, std::vector<GLfloat> pos, std::vector<GLfloat> dir, float cut, float exp); //ID (GL_LIGHTX), light position, spot cutoff, spot exponent
		~SpotLight();

		//Overrides
		void Render() override;

	private:
		std::vector<GLfloat> _Direction;	//Direction the spot light is facing (Up or down X, Y or Z axis)
		float _Cutoff;
		float _Exponent;
};

